//LidPosts.scad;

//This is version 2022_03_11;
//Previous versions used separate 
//files: 
//LidPostWithHole and 
//LidPostNoHole.scad;
//The ...posts module called 
//the other module(s) four times 
//to generate four posts, with their holes;
//That was confusing and for this version, 
//this module generates all four posts, 
//but without their holes;
//A separate module: LidPostHoles 
//generates the four holes;
//Hopefully, that will be slightly less confusing;
//Hopefully;

//The body of each post is made from two parts:
//1:
//A cylinder, with a hole for a screw;
//2:
//A cube to fill the space between that 
//cylinder and the wall to which it is attached;

//This module places the posts where 
//they are required;
//The calling module should not tinker 
//with that placement; 
//With luck, the holes in the posts 
//will align with those in the floor, 
//generated by LidScrewThreads;
//With luck;

include <BATT_Dimensions.scad>

module LidPosts()
{

echo("Begin LidPosts");
    
//DeltaZ is constant for all posts;
//The posts must allow room for two floors 
//and the flange to align the case for the UNO;
DeltaZ = 3*FloorZ +PostLidHeight/2;

//Two posts on the front wall;
//echo("Post BL = ", LidBLx, LidBLy);
translate([LidBLx, LidBLy, DeltaZ])
    {
        cylinder(h=PostLidHeight,
            d=PostLidPhi, 
            center=true, $fn=32);

        translate([0, -PostLidPhi/2, 0])
        cube([PostLidPhi, PostLidPhi, 
            PostLidHeight], center=true);
    }

//echo("Post BR = ", LidBRx, LidBRy);
translate([LidBRx, LidBRy, DeltaZ])
    {
        cylinder(h=PostLidHeight,
            d=PostLidPhi, 
            center=true, $fn=32);

        translate([0, -PostLidPhi/2, 0])
        cube([PostLidPhi, PostLidPhi, 
            PostLidHeight], center=true);
    }

//Two posts on the rear wall;
//echo("Post TR = ", LidTRx, LidTRy);
translate([LidTRx, LidTRy, DeltaZ])
    {
        cylinder(h=PostLidHeight,
            d=PostLidPhi, 
            center=true, $fn=32);

        translate([0, PostLidPhi/2, 0])
        cube([PostLidPhi, PostLidPhi, 
            PostLidHeight], center=true);
    }

//echo("Post TL = ", LidTLx, LidTLy);
translate([LidTLx, LidTLy, DeltaZ])
    {
        cylinder(h=PostLidHeight,
            d=PostLidPhi, 
            center=true, $fn=32);

        translate([0, PostLidPhi/2, 0])
        cube([PostLidPhi, PostLidPhi, 
            PostLidHeight], center=true);
    }

}
//
